/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.toolkit.admin.result.IVWAdminTextEditChangeEventListener;
import filenet.vw.toolkit.admin.result.VWAdminLockWork;
import filenet.vw.toolkit.admin.result.VWAdminMenuUpdateEvent;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminStatisticsTableModel;
import filenet.vw.toolkit.admin.result.VWAdminTextEditChangeEvent;
import filenet.vw.toolkit.admin.result.VWAdminWOTableModel;
import filenet.vw.toolkit.admin.result.images.VWImageLoader;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.Caret;

public class VWAdminResultControlsPanel
extends JPanel
implements ActionListener,
KeyListener {
    protected static final int OFFSET_HORIZ = 10;
    private JLabel m_iconLabel = null;
    private Icon m_icon = null;
    private JLabel m_setLabel = null;
    private JLabel m_valueLabel = null;
    private JTextField m_valueTextField = null;
    private Color m_enabledBkgrndColor = SystemColor.text;
    private VWAdminResultPane m_resultsPane;
    private boolean m_bLocked = false;
    private AbstractButton m_editFieldsButton = null;
    private AbstractButton m_nextSetButton = null;
    private AbstractButton m_showHideColumnsButton = null;
    private AbstractButton m_selectColumnButton = null;
    private AbstractButton m_lockButton = null;
    private AbstractButton m_unlockButton = null;
    private AbstractButton m_unlockAllButton = null;
    private AbstractButton m_saveButton = null;
    private AbstractButton m_saveAllButton = null;
    private AbstractButton m_cancelButton = null;
    private AbstractButton m_cancelAllButton = null;
    private AbstractButton m_refreshButton = null;
    private AbstractButton m_openItemButton = null;
    private AbstractButton m_openTrackerButton = null;
    private AbstractButton m_openStepProcessorButton = null;
    private Vector<IVWAdminTextEditChangeEventListener> m_textEditChangeEventListeners = new Vector();

    public VWAdminResultControlsPanel(VWAdminResultPane pane) {
        try {
            this.m_resultsPane = pane;
            this.initPanel();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_valueTextField) {
            this.fireTextEditChanged(this.m_valueTextField.getText());
        } else {
            if (object == this.m_editFieldsButton) {
                this.m_resultsPane.performEditFieldsAction();
            } else if (object == this.m_nextSetButton) {
                this.m_resultsPane.performNextSetAction();
            } else if (object == this.m_refreshButton) {
                this.m_resultsPane.performRefreshAction();
            } else if (object == this.m_openItemButton) {
                this.m_resultsPane.performOpenItemAction(-1);
            } else if (object == this.m_openTrackerButton) {
                this.m_resultsPane.performOpenItemAction(0);
            } else if (object == this.m_openStepProcessorButton) {
                this.m_resultsPane.performOpenItemAction(1);
            } else if (object == this.m_showHideColumnsButton) {
                this.m_resultsPane.performShowHideColumnsAction();
            } else if (object == this.m_selectColumnButton) {
                this.m_resultsPane.performSelectColumnAction();
            } else if (object == this.m_lockButton) {
                this.m_resultsPane.performLockAction();
            } else if (object == this.m_unlockButton) {
                this.m_resultsPane.performUnlockAction(false);
            } else if (object == this.m_unlockAllButton) {
                this.m_resultsPane.performUnlockAction(true);
            } else if (object == this.m_saveButton) {
                this.m_resultsPane.performSaveAction(false);
            } else if (object == this.m_saveAllButton) {
                this.m_resultsPane.performSaveAction(true);
            } else if (object == this.m_cancelButton) {
                this.m_resultsPane.performCancelAction(false);
            } else if (object == this.m_cancelAllButton) {
                this.m_resultsPane.performCancelAction(true);
            } else {
                return;
            }
            FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.m_bLocked) {
            return;
        }
        this.m_bLocked = true;
        this.setEditableTextField(false);
        VWAdminLockWork lockWork = new VWAdminLockWork(this.m_resultsPane, VWResource.s_editFieldsTitle, VWResource.s_askEdit, VWResource.s_override);
        boolean b_cancel = lockWork.getReturnStatus();
        if (b_cancel) {
            this.m_bLocked = false;
            return;
        }
        this.setEditableTextField(true);
        this.m_bLocked = false;
    }

    public void keyReleased(KeyEvent e) {
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_setLabel != null) {
            Font font = this.m_setLabel.getFont();
            this.m_setLabel.setFont(new Font(font.getName(), 1, 14));
        }
    }

    protected void update() {
        this.setVisible(true);
        this.setControlsVisibility(true);
        this.disableAll();
        this.updateIconLabel();
        this.updateSetLabel();
    }

    protected void enableDisableButtons(VWAdminMenuUpdateEvent e) {
        if (this.m_resultsPane == null || this.m_resultsPane.getResultsTable() == null || this.m_resultsPane.getTableModel() == null) {
            return;
        }
        this.setButtonEnabledDisabled(this.m_selectColumnButton, e.getSelectColumn());
        this.setButtonEnabledDisabled(this.m_showHideColumnsButton, e.getShowHideColumns());
        this.setButtonEnabledDisabled(this.m_openTrackerButton, e.getOpenTracker());
        this.setButtonEnabledDisabled(this.m_openStepProcessorButton, e.getOpenStepProcessor());
        if (!(this.m_resultsPane.getTableModel() instanceof VWAdminStatisticsTableModel)) {
            this.setButtonEnabledDisabled(this.m_nextSetButton, e.getNextSet());
        }
        if (this.m_resultsPane.getTableModel() instanceof VWAdminWOTableModel) {
            this.setButtonEnabledDisabled(this.m_refreshButton, e.getRefresh());
            this.setButtonEnabledDisabled(this.m_lockButton, e.getLock());
            this.setButtonEnabledDisabled(this.m_unlockButton, e.getUnlock());
            this.setButtonEnabledDisabled(this.m_saveButton, e.getSave());
            this.setButtonEnabledDisabled(this.m_cancelButton, e.getCancel());
            this.setButtonEnabledDisabled(this.m_editFieldsButton, e.getEditFields());
            this.setButtonEnabledDisabled(this.m_unlockAllButton, e.getUnlockAll());
            this.setButtonEnabledDisabled(this.m_saveAllButton, e.getSaveAll());
            this.setButtonEnabledDisabled(this.m_cancelAllButton, e.getCancelAll());
        }
    }

    protected void updateTextField(String newValue) {
        this.m_valueTextField.setEnabled(true);
        this.m_valueTextField.setEditable(true);
        this.m_valueTextField.setText(newValue);
        this.m_valueTextField.setBackground(this.m_enabledBkgrndColor);
    }

    protected void clearAndDisableTextField() {
        if (this.m_valueTextField != null) {
            this.m_valueTextField.setText(VWResource.s_emptyString);
            this.m_valueTextField.setEnabled(false);
            this.m_valueTextField.setBackground(this.getBackground());
        }
    }

    protected void setEditableTextField(boolean editable) {
        this.m_valueTextField.setEditable(editable);
        Caret caret = this.m_valueTextField.getCaret();
        if (!caret.isVisible()) {
            caret.setVisible(true);
        }
    }

    protected void disableAll() {
        this.clearAndDisableTextField();
        this.setButtonEnabledDisabled(this.m_showHideColumnsButton, false);
        this.setButtonEnabledDisabled(this.m_selectColumnButton, false);
        this.setButtonEnabledDisabled(this.m_nextSetButton, false);
        this.setButtonEnabledDisabled(this.m_openTrackerButton, false);
        this.setButtonEnabledDisabled(this.m_openStepProcessorButton, false);
        this.setButtonEnabledDisabled(this.m_refreshButton, false);
        this.setButtonEnabledDisabled(this.m_lockButton, false);
        this.setButtonEnabledDisabled(this.m_unlockButton, false);
        this.setButtonEnabledDisabled(this.m_unlockAllButton, false);
        this.setButtonEnabledDisabled(this.m_saveButton, false);
        this.setButtonEnabledDisabled(this.m_saveAllButton, false);
        this.setButtonEnabledDisabled(this.m_cancelButton, false);
        this.setButtonEnabledDisabled(this.m_cancelAllButton, false);
        this.setButtonEnabledDisabled(this.m_editFieldsButton, false);
    }

    protected void setControlsVisibility(boolean visible) {
        this.m_iconLabel.setVisible(visible);
        this.m_setLabel.setVisible(visible);
        this.m_valueLabel.setVisible(visible);
        this.m_valueTextField.setText(VWResource.s_emptyString);
        this.m_valueTextField.setVisible(visible);
        this.m_nextSetButton.setVisible(visible);
        this.m_openTrackerButton.setVisible(visible);
        this.m_openStepProcessorButton.setVisible(visible);
        this.m_refreshButton.setVisible(visible);
        this.m_lockButton.setVisible(visible);
        this.m_unlockButton.setVisible(visible);
        this.m_unlockAllButton.setVisible(visible);
        this.m_saveButton.setVisible(visible);
        this.m_saveAllButton.setVisible(visible);
        this.m_cancelButton.setVisible(visible);
        this.m_cancelAllButton.setVisible(visible);
        this.m_editFieldsButton.setVisible(visible);
        this.m_showHideColumnsButton.setVisible(visible);
        this.m_showHideColumnsButton.setRolloverEnabled(visible);
        this.m_selectColumnButton.setVisible(visible);
    }

    protected void fireTextEditChanged(String editValue) {
        VWAdminTextEditChangeEvent event = new VWAdminTextEditChangeEvent(this, editValue);
        for (int i = 0; i < this.m_textEditChangeEventListeners.size(); ++i) {
            this.m_textEditChangeEventListeners.elementAt(i).textEditChanged(event);
        }
    }

    protected void addTextEditChangeEventListener(IVWAdminTextEditChangeEventListener listener) {
        this.m_textEditChangeEventListeners.addElement(listener);
    }

    protected void removeTextEditChangeEventListener(IVWAdminTextEditChangeEventListener listener) {
        this.m_textEditChangeEventListeners.removeElement(listener);
    }

    private void updateSetLabel() {
        int setNum = 0;
        if (this.m_resultsPane != null && this.m_resultsPane.getResultsTable() != null && this.m_resultsPane.getTableModel() != null && this.m_resultsPane.getResultsTable().getRowCount() > 0) {
            setNum = this.m_resultsPane.getTableModel() instanceof VWAdminStatisticsTableModel ? 1 : this.m_resultsPane.getTableModel().getSetNum();
        }
        String text = VWResource.s_setLabel + setNum;
        this.m_setLabel.setText(text);
        VWAccessibilityHelper.setAccessibility(this.m_setLabel, this, text, text);
    }

    private void updateIconLabel() {
        this.m_icon = VWImageLoader.createImageIcon("readonly.gif");
        String tooltip = VWResource.s_readonlyMode;
        if (this.m_resultsPane != null && this.m_resultsPane.getResultsTable() != null && this.m_resultsPane.getTableModel() != null && this.m_resultsPane.getTableModel() instanceof VWAdminWOTableModel) {
            this.m_icon = VWImageLoader.createImageIcon("editmode.gif");
            tooltip = VWResource.s_editMode;
        }
        this.m_iconLabel.setIcon(this.m_icon);
        this.m_iconLabel.setToolTipText(tooltip);
    }

    private AbstractButton addToolBarButton(JToolBar toolBar, String fileName, String toolTip, boolean bUseToggleButton, ActionListener actionListener) {
        AbstractButton button = VWImageLoader.createToolBarButton(fileName, toolTip, bUseToggleButton);
        if (button != null) {
            toolBar.add(button);
            button.setRolloverEnabled(true);
            if (actionListener != null) {
                button.addActionListener(actionListener);
            }
        }
        return button;
    }

    private JToolBar getMainToolBar() {
        JToolBar mainToolBar = new JToolBar();
        mainToolBar.setFloatable(false);
        mainToolBar.setMargin(new Insets(0, 0, 0, 0));
        this.m_iconLabel = new JLabel();
        this.m_icon = VWImageLoader.createImageIcon("readonly.gif");
        this.m_iconLabel.setIcon(this.m_icon);
        this.m_iconLabel.setToolTipText(VWResource.s_readonlyMode);
        mainToolBar.add(this.m_iconLabel);
        VWImageLoader.addToolbarSeparator(mainToolBar);
        this.m_nextSetButton = this.addToolBarButton(mainToolBar, "next.gif", VWResource.s_nextSetMenuToolTip, false, this);
        String text = VWResource.s_setLabel + 1;
        this.m_setLabel = new JLabel(text);
        VWAccessibilityHelper.setAccessibility(this.m_setLabel, this, text, text);
        mainToolBar.add(this.m_setLabel);
        VWImageLoader.addToolbarSeparator(mainToolBar);
        this.m_refreshButton = this.addToolBarButton(mainToolBar, "refresh.gif", VWResource.s_refreshMenuToolTip, false, this);
        VWImageLoader.addToolbarSeparator(mainToolBar);
        this.m_openTrackerButton = this.addToolBarButton(mainToolBar, "launchtrack.gif", VWResource.s_openTrackerDotsMenuToolTip, false, this);
        this.m_openStepProcessorButton = this.addToolBarButton(mainToolBar, "launchstep.gif", VWResource.s_openStepProcessorDotsMenuToolTip, false, this);
        VWImageLoader.addToolbarSeparator(mainToolBar);
        this.m_lockButton = this.addToolBarButton(mainToolBar, "lock.gif", VWResource.s_lockMenuToolTip, false, this);
        this.m_unlockButton = this.addToolBarButton(mainToolBar, "unlock.gif", VWResource.s_unlockMenuToolTip, false, this);
        this.m_unlockAllButton = this.addToolBarButton(mainToolBar, "unlock_all.gif", VWResource.s_unlockAllMenuToolTip, false, this);
        VWImageLoader.addToolbarSeparator(mainToolBar);
        this.m_saveButton = this.addToolBarButton(mainToolBar, "save.gif", VWResource.s_saveMenuToolTip, false, this);
        this.m_saveAllButton = this.addToolBarButton(mainToolBar, "save_all.gif", VWResource.s_saveAllMenuToolTip, false, this);
        VWImageLoader.addToolbarSeparator(mainToolBar);
        this.m_cancelButton = this.addToolBarButton(mainToolBar, "cancel.gif", VWResource.s_discardMenuToolTip, false, this);
        this.m_cancelAllButton = this.addToolBarButton(mainToolBar, "cancel_all.gif", VWResource.s_discardAllMenuToolTip, false, this);
        VWImageLoader.addToolbarSeparator(mainToolBar);
        return mainToolBar;
    }

    private JToolBar getMiscToolBar() {
        JToolBar miscToolBar = new JToolBar();
        miscToolBar.setFloatable(false);
        miscToolBar.setMargin(new Insets(0, 0, 0, 0));
        VWImageLoader.addToolbarSeparator(miscToolBar);
        this.m_editFieldsButton = this.addToolBarButton(miscToolBar, "editfields.gif", VWResource.s_editFieldsDotsMenuToolTip, false, this);
        this.m_showHideColumnsButton = this.addToolBarButton(miscToolBar, "columns.gif", VWResource.s_showHideColumnsDotsMenuToolTip, false, this);
        this.m_selectColumnButton = this.addToolBarButton(miscToolBar, "select.gif", VWResource.s_selectColumnMenuToolTip, false, this);
        return miscToolBar;
    }

    private void initPanel() {
        this.removeAll();
        Color bgColor = this.getBackground();
        this.setBackground(bgColor);
        GridBagLayout layoutBox = new GridBagLayout();
        this.setLayout(layoutBox);
        GridBagConstraints gbCons = null;
        gbCons = new GridBagConstraints();
        gbCons.anchor = 21;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.gridx = -1;
        gbCons.gridy = 0;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getMainToolBar(), gbCons);
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_valueLabel = new JLabel(VWResource.s_valueLabel);
        VWAccessibilityHelper.setAccessibility(this.m_valueLabel, this, VWResource.s_valueLabel, VWResource.s_valueLabel);
        this.add((Component)this.m_valueLabel, gbCons);
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.insets = new Insets(0, 5, 0, 0);
        this.m_valueTextField = new JTextField();
        this.m_enabledBkgrndColor = this.m_valueTextField.getBackground();
        this.clearAndDisableTextField();
        this.add((Component)this.m_valueTextField, gbCons);
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getMiscToolBar(), gbCons);
        VWAccessibilityHelper.setAccessibility(this.m_valueTextField, this, VWResource.s_valueLabel, VWResource.s_valueLabel);
        VWAccessibilityHelper.setLabelFor(this.m_valueLabel, this.m_valueTextField);
        this.m_valueTextField.addActionListener(this);
        this.m_valueTextField.addKeyListener(this);
        this.disableAll();
        this.setControlsVisibility(false);
        this.setVisible(false);
    }

    private void setButtonEnabledDisabled(AbstractButton button, boolean bEnabled) {
        button.setEnabled(bEnabled);
        button.setRolloverEnabled(bEnabled);
    }
}

